/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.sensor;

import java.io.Serializable;
import java.util.Collection;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.config.Settings;
import org.sonar.api.design.Dependency;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.PathUtils;
import org.sonar.api.utils.System2;
import org.sonarsource.sonarlint.core.analyzer.sensor.DefaultSensorContext;

public class LtsApiSensorContext
extends DefaultSensorContext
implements SensorContext {
    private final Project project;

    public LtsApiSensorContext(Project project, Settings settings, FileSystem fs, ActiveRules activeRules, SensorStorage sensorStorage) {
        super(settings, fs, activeRules, sensorStorage);
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public boolean index(Resource resource) {
        throw LtsApiSensorContext.unsupported();
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Unsupported in SonarLint");
    }

    @Override
    public boolean index(Resource resource, Resource parentReference) {
        throw LtsApiSensorContext.unsupported();
    }

    @Override
    public boolean isExcluded(Resource reference) {
        throw LtsApiSensorContext.unsupported();
    }

    @Override
    public boolean isIndexed(Resource reference, boolean acceptExcluded) {
        throw LtsApiSensorContext.unsupported();
    }

    @Override
    public Resource getParent(Resource reference) {
        throw LtsApiSensorContext.unsupported();
    }

    @Override
    public Collection<Resource> getChildren(Resource reference) {
        throw LtsApiSensorContext.unsupported();
    }

    @Override
    public <G extends Serializable> Measure<G> getMeasure(Metric<G> metric) {
        throw LtsApiSensorContext.unsupported();
    }

    @Override
    public <M> M getMeasures(MeasuresFilter<M> filter) {
        throw LtsApiSensorContext.unsupported();
    }

    @Override
    public Measure saveMeasure(Measure measure) {
        return null;
    }

    @Override
    public Measure saveMeasure(Metric metric, Double value) {
        return null;
    }

    @Override
    public <G extends Serializable> Measure<G> getMeasure(Resource resource, Metric<G> metric) {
        throw LtsApiSensorContext.unsupported();
    }

    @Override
    public String saveResource(Resource resource) {
        throw LtsApiSensorContext.unsupported();
    }

    public boolean saveResource(Resource resource, Resource parentReference) {
        throw LtsApiSensorContext.unsupported();
    }

    public Resource getResource(Resource resource) {
        String absolutePath = resource.getKey();
        if (!System2.INSTANCE.isOsWindows() && !absolutePath.startsWith("/")) {
            absolutePath = "/" + resource.getKey();
        }
        resource.setEffectiveKey(absolutePath).setPath(absolutePath).setKey(absolutePath);
        return resource;
    }

    @Override
    public <M> M getMeasures(Resource resource, MeasuresFilter<M> filter) {
        throw LtsApiSensorContext.unsupported();
    }

    @Override
    public Measure saveMeasure(Resource resource, Metric metric, Double value) {
        return null;
    }

    @Override
    public Measure saveMeasure(Resource resource, Measure measure) {
        return null;
    }

    @Override
    public Dependency saveDependency(Dependency dependency) {
        return null;
    }

    @Override
    public void saveSource(Resource reference, String source) {
        throw LtsApiSensorContext.unsupported();
    }

    @Override
    public Measure saveMeasure(InputFile inputFile, Metric metric, Double value) {
        return null;
    }

    @Override
    public Measure saveMeasure(InputFile inputFile, Measure measure) {
        return null;
    }

    @Override
    public Resource getResource(final InputPath inputPath) {
        if (inputPath.isFile()) {
            File f = new File(inputPath.absolutePath()){

                @Override
                public String getEffectiveKey() {
                    return inputPath.key();
                }

                @Override
                public String getPath() {
                    return inputPath.absolutePath();
                }

                @Override
                public Directory getParent() {
                    return Directory.create(PathUtils.sanitize(inputPath.path().getParent().toString()));
                }
            };
            f.setKey(inputPath.key());
            return f;
        }
        return new FakeResourceForSonarLint(inputPath);
    }

    private static final class FakeResourceForSonarLint
    extends Resource {
        private final InputPath inputPath;

        private FakeResourceForSonarLint(InputPath inputPath) {
            this.inputPath = inputPath;
        }

        @Override
        public String getEffectiveKey() {
            return this.inputPath.key();
        }

        @Override
        public String getPath() {
            return this.inputPath.absolutePath();
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getLongName() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public Language getLanguage() {
            return null;
        }

        @Override
        public String getScope() {
            return null;
        }

        @Override
        public String getQualifier() {
            return null;
        }

        @Override
        public Resource getParent() {
            return null;
        }

        @Override
        public boolean matchFilePattern(String antPattern) {
            return false;
        }
    }
}

